/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.model.resource;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import rpgboss.model.resource.ResourceException;
import rpgboss.model.resource.RpgAssetManager;
import rpgboss.model.resource.TiledImageResource;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public abstract class TiledImageResource$class {
    public static int xTiles(TiledImageResource $this) {
        return $this.img().getWidth() / $this.tileW();
    }

    public static int yTiles(TiledImageResource $this) {
        return $this.img().getHeight() / $this.tileH();
    }

    public static boolean inBounds(TiledImageResource $this, int xTile, int yTile) {
        return xTile >= 0 && xTile < $this.xTiles() && yTile >= 0 && yTile < $this.yTiles();
    }

    public static boolean drawTileAt(TiledImageResource $this, int ti, int tj, Graphics g, int dstX, int dstY) {
        if (ti < $this.img().getWidth() / $this.tileW() && tj < $this.img().getHeight() / $this.tileH()) {
            return g.drawImage($this.img(), dstX, dstY, dstX + $this.tileW(), dstY + $this.tileH(), ti * $this.tileW(), tj * $this.tileH(), ti * $this.tileW() + $this.tileW(), tj * $this.tileH() + $this.tileH(), null);
        }
        throw new ResourceException(new StringBuilder().append((Object)"Requested tile out of bounds. ").append((Object)new StringOps(Predef$.MODULE$.augmentString("(name=%s, ti=%d, tj=%d)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{$this.name(), BoxesRunTime.boxToInteger(ti), BoxesRunTime.boxToInteger(tj)}))).toString());
    }

    public static BufferedImage getTileImage(TiledImageResource $this, int ti, int tj) {
        if (ti < $this.img().getWidth() / $this.tileW() && tj < $this.img().getHeight() / $this.tileH()) {
            return $this.img().getSubimage(ti * $this.tileW(), tj * $this.tileH(), $this.tileW(), $this.tileH());
        }
        throw new ResourceException(new StringBuilder().append((Object)"Requested tile out of bounds. ").append((Object)new StringOps(Predef$.MODULE$.augmentString("(name=%s, ti=%d, tj=%d)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{$this.name(), BoxesRunTime.boxToInteger(ti), BoxesRunTime.boxToInteger(tj)}))).toString());
    }

    public static Tuple2 srcTexels(TiledImageResource $this, int xTile, int yTile) {
        return new Tuple2$mcII$sp(xTile * $this.tileW(), yTile * $this.tileH());
    }

    public static void drawTileAt(TiledImageResource $this, SpriteBatch batch, Texture texture, float dstX, float dstY, float dstW, float dstH, int xTile, int yTile, int texelXOffset, int texelYOffset) {
        int srcXOffsetted = texelXOffset + xTile * $this.tileW();
        int srcYOffsetted = texelYOffset + yTile * $this.tileH();
        batch.draw(texture, dstX, dstY, dstW, dstH, srcXOffsetted, srcYOffsetted, $this.tileW(), $this.tileH(), false, true);
    }

    public static int drawTileAt$default$9(TiledImageResource $this) {
        return 0;
    }

    public static int drawTileAt$default$10(TiledImageResource $this) {
        return 0;
    }

    public static void drawTileCentered(TiledImageResource $this, SpriteBatch batch, RpgAssetManager assets, float dstX, float dstY, int xTile, int yTile, float sizeScale) {
        Predef$.MODULE$.assert($this.isLoaded(assets));
        Texture texture = (Texture)$this.getAsset(assets, ManifestFactory$.MODULE$.classType(Texture.class));
        $this.drawTileAt(batch, texture, dstX - (float)$this.tileW() / 2.0f, dstY - (float)$this.tileH() / 2.0f, (float)$this.tileW() * sizeScale, (float)$this.tileH() * sizeScale, xTile, yTile, $this.drawTileAt$default$9(), $this.drawTileAt$default$10());
    }

    public static void $init$(TiledImageResource $this) {
    }
}

